@echo off
title Instalador SIREMA
color 0A

:: ===============================
:: VARIABLES
:: ===============================
set ZIP_URL=https://tools.uvm.thais.ovh/download/SIREMA/Sirema.zip
set DOWNLOAD_DIR=%USERPROFILE%\Downloads
set ZIP_FILE=%DOWNLOAD_DIR%\Sirema.zip
set EXTRACT_DIR=%DOWNLOAD_DIR%
set SOURCE_FOLDER=%DOWNLOAD_DIR%\Sirema
set TARGET_FOLDER=C:\Sirema
set REG_FILE=C:\Sirema\reg.reg
set EXE_FILE=C:\Sirema\Sirema.exe

echo ===============================
echo   INSTALANDO SIREMA
echo ===============================
echo.

:: ===============================
:: CHECK ADMIN
:: ===============================
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Ejecuta este script como ADMINISTRADOR
    pause
    exit /b
)

:: ===============================
:: DOWNLOAD ZIP
:: ===============================
echo Descargando Sirema.zip...
powershell -Command "Invoke-WebRequest -Uri '%ZIP_URL%' -OutFile '%ZIP_FILE%'"
if not exist "%ZIP_FILE%" (
    echo [ERROR] No se pudo descargar el ZIP
    pause
    exit /b
)

:: ===============================
:: UNZIP
:: ===============================
echo Extrayendo ZIP...
powershell -Command "Expand-Archive -Force '%ZIP_FILE%' '%EXTRACT_DIR%'"

if not exist "%SOURCE_FOLDER%" (
    echo [ERROR] Carpeta Sirema no encontrada
    pause
    exit /b
)

:: ===============================
:: COPY TO C:\
:: ===============================
echo Copiando Sirema a C:\ ...
if exist "%TARGET_FOLDER%" (
    rmdir /s /q "%TARGET_FOLDER%"
)

xcopy "%SOURCE_FOLDER%" "%TARGET_FOLDER%" /E /I /H /Y

:: ===============================
:: IMPORT REGISTRY
:: ===============================
if not exist "%REG_FILE%" (
    echo [ERROR] Archivo REG no encontrado en C:\Sirema
    pause
    exit /b
)

echo Importando registro...
reg import "%REG_FILE%"

:: ===============================
:: RUN SIREMA AS ADMIN
:: ===============================
if not exist "%EXE_FILE%" (
    echo [ERROR] Sirema.exe no encontrado
    pause
    exit /b
)

echo Ejecutando Sirema.exe como Administrador...
powershell -Command "Start-Process '%EXE_FILE%' -Verb RunAs"

echo Esperando 60 segundos antes de reiniciar...
timeout /t 60

:: ===============================
:: RESTART
:: ===============================
echo.
echo Instalación completa.
echo Reiniciando en 10 segundos...
timeout /t 10
shutdown /r /t 0